/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.container;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.helpers.InterfaceLogic;
import appeng.helpers.InterfaceLogicHost;
import appeng.menu.SlotSemantic;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.SetStockAmountMenu;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.locator.MenuLocator;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.FakeSlot;
import appeng.util.ConfigMenuInventory;
import com.github.glodblock.extendedae.api.IPage;
import com.github.glodblock.extendedae.client.ExSemantics;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class ContainerExInterface
extends UpgradeableMenu<InterfaceLogicHost>
implements IPage {
    public static final String ACTION_OPEN_SET_AMOUNT = "setAmount";
    public static final class_3917<ContainerExInterface> TYPE = MenuTypeBuilder.create(ContainerExInterface::new, InterfaceLogicHost.class).build("ex_interface");
    private static final int PAGE = 18;
    private static final int LINE = 9;
    private static final SlotSemantic[] CONFIG_PATTERN = new SlotSemantic[]{ExSemantics.EX_1, ExSemantics.EX_3, ExSemantics.EX_5, ExSemantics.EX_7};
    private static final SlotSemantic[] STORAGE_PATTERN = new SlotSemantic[]{ExSemantics.EX_2, ExSemantics.EX_4, ExSemantics.EX_6, ExSemantics.EX_8};
    private final List<class_1735> configSlots = new ArrayList<class_1735>();
    @GuiSync(value=7)
    public int page;

    public ContainerExInterface(int id, class_1661 ip, InterfaceLogicHost host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
        this.registerClientAction(ACTION_OPEN_SET_AMOUNT, Integer.class, this::openSetAmountMenu);
        InterfaceLogic logic = host.getInterfaceLogic();
        ConfigMenuInventory config = logic.getConfig().createMenuWrapper();
        for (int x = 0; x < config.size(); ++x) {
            int page = x / 18;
            int row = (x - page * 18) / 9;
            this.configSlots.add(this.addSlot((class_1735)new FakeSlot((InternalInventory)config, x), CONFIG_PATTERN[2 * page + row]));
        }
        ConfigMenuInventory storage = logic.getStorage().createMenuWrapper();
        for (int x = 0; x < storage.size(); ++x) {
            int page = x / 18;
            int row = (x - page * 18) / 9;
            this.addSlot((class_1735)new AppEngSlot((InternalInventory)storage, x), STORAGE_PATTERN[2 * page + row]);
        }
    }

    public List<class_1735> getConfigSlots() {
        return this.configSlots;
    }

    public void showPage(int page) {
        for (int index = 0; index < 4; ++index) {
            List slots = this.getSlots(CONFIG_PATTERN[index]);
            slots.addAll(this.getSlots(STORAGE_PATTERN[index]));
            for (class_1735 slot : slots) {
                if (!(slot instanceof AppEngSlot)) continue;
                AppEngSlot as = (AppEngSlot)slot;
                as.setActive(page == index / 2);
            }
        }
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setFuzzyMode((FuzzyMode)cm.getSetting(Settings.FUZZY_MODE));
    }

    public void openSetAmountMenu(int configSlot) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_OPEN_SET_AMOUNT, configSlot);
        } else {
            GenericStack stack = ((InterfaceLogicHost)this.getHost()).getConfig().getStack(configSlot);
            if (stack != null) {
                SetStockAmountMenu.open((class_3222)((class_3222)this.getPlayer()), (MenuLocator)this.getLocator(), (int)configSlot, (AEKey)stack.what(), (int)((int)stack.amount()));
            }
        }
    }

    public void method_7623() {
        IUpgradeableObject iUpgradeableObject = this.getHost();
        if (iUpgradeableObject instanceof IPage) {
            IPage pg = (IPage)iUpgradeableObject;
            this.page = pg.getPage();
        }
        super.method_7623();
    }

    @Override
    public void setPage(int page) {
        this.page = page;
        IUpgradeableObject iUpgradeableObject = this.getHost();
        if (iUpgradeableObject instanceof IPage) {
            IPage pg = (IPage)iUpgradeableObject;
            pg.setPage(page);
        }
    }

    @Override
    public int getPage() {
        return this.page;
    }
}

